@echo off
chcp 936

set script_dir=%~dp0

echo Current script directory: %script_dir%
echo --- Start retrieving system proxy information ---

REM Use PowerShell to get ProxyEnable and ProxyServer values
for /f "delims=" %%A in ('powershell -Command "(Get-ItemProperty 'HKCU:\Software\Microsoft\Windows\CurrentVersion\Internet Settings').ProxyEnable"') do set ProxyEnable=%%A
for /f "delims=" %%B in ('powershell -Command "(Get-ItemProperty 'HKCU:\Software\Microsoft\Windows\CurrentVersion\Internet Settings').ProxyServer"') do set ProxyServer=%%B

echo Proxy enabled: %ProxyEnable%
echo Proxy server: %ProxyServer%

REM Check if proxy is enabled and proxy server is not empty
if "%ProxyEnable%"=="1" (
    if not "%ProxyServer%"=="" (
        echo --- Proxy server detected, backing up and updating libmpv.js ---

        REM Backup libmpv.js file
        echo Backing up file: %script_dir%electronapp\plugins\libmpv.js to %script_dir%electronapp\plugins\libmpv_backup.js
        copy "%script_dir%electronapp\plugins\libmpv.js" "%script_dir%electronapp\plugins\libmpv_backup.js"
        
        REM Call PowerShell script to update libmpv.js
        echo Calling PowerShell to update libmpv.js
        powershell -ExecutionPolicy Bypass -File "%script_dir%update_mpv.ps1" "%ProxyServer%"

        if %errorlevel% neq 0 (
            echo Error occurred during PowerShell execution, please check update_mpv.ps1 output.
        ) else (
            echo libmpv.js updated successfully.
        )
    ) else (
        echo No proxy server detected.
    )
) else (
    echo Proxy not enabled.
)

pause
